<pre><?php

// header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
// header("Cache-Control: post-check=0, pre-check=0", false);
// header("Pragma: no-cache");

error_reporting(1);
date_default_timezone_set('America/New_York');

$token_date = date("YmdGis", filemtime("./access_token.txt"));
$now = date("YmdGis");

$time_since_token = $now - $token_date;
$time_to_expire = 1800 - $time_since_token;

//print("<small>token retrieved " . $time_since_token . "s ago ($now - $token_date) and expires in: " . $time_to_expire . "s</small><br>");

if($time_to_expire <= 60){
    $access_token = update_token();
    echo "Updated token.\n";
}

function calculate_date_offset($dayOfWeek) {
    switch ($dayOfWeek) {
        case '0':
            return 1;
        case '6':
            return 3;
        case '7':
            return 2;
        default:
            return 0;
    }
}

function update_token() {
    $tokens = array();
    $refresh_token = trim(file_get_contents("./refresh_token.txt"));
    $cmd = 'curl -X POST --header "Content-Type: application/x-www-form-urlencoded" --header "Authorization: Basic {' . base64_encode("bOGMvBTAXhmi0zG5QqGQhowEwDNMZujB:cujUmUZiLZh2L3gs") . '}" -d "grant_type=refresh_token" -d "refresh_token=' . $refresh_token . '" "https://api.schwabapi.com/v1/oauth/token"';
    $tokens = json_decode(shell_exec($cmd), true);
    //
    //print_r($tokens);

    if(is_array($tokens) && array_key_exists('error', $tokens)){
        print($tokens['error_description']);
        print("<hr>");
        if(trim($tokens['error_description'])){
            print($tokens['error_description']);
            print("<hr>");
            print("<a href='https://api.schwabapi.com/v1/oauth/authorize?client_id=bOGMvBTAXhmi0zG5QqGQhowEwDNMZujB&redirect_uri=https://127.0.0.1' target='_blank'>Please login to Schwab again</a>");
            exit();
        }
    }
    file_put_contents("./access_token.txt", $tokens['access_token']);
    file_put_contents("./refresh_token.txt", $tokens['refresh_token']);
    file_put_contents("./id_token.txt", $tokens['id_token']);
    return $tokens['access_token'];
}

function get_account_numbers($access_token) {
    $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/trader/v1/accounts/accountNumbers"';
    return json_decode(shell_exec($cmd), true);
}

function get_account_data($access_token, $hashValue) {
    $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '"';
    return json_decode(shell_exec($cmd), true);
}

function get_positions($access_token, $hashValue) {
    $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/trader/v1/accounts?fields=positions"';
    return json_decode(shell_exec($cmd), true);
}

function get_orders($access_token, $hashValue) {
    $orders = array();
    $from = date("Y-m-d");
    $to = date("Y-m-d", strtotime("+1 days"));
    $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '/orders?fromEnteredTime=' . $from . 'T00%3A00%3A00.000Z&toEnteredTime=' . $to . 'T23%3A59%3A59.999Z&status=WORKING"';
    $orders = json_decode(shell_exec($cmd), true);

    if(is_array($orders) && !array_key_exists('0', $orders)){
        $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '/orders?fromEnteredTime=' . $from . 'T00%3A00%3A00.000Z&toEnteredTime=' . $to . 'T23%3A59%3A59.999Z&status=PENDING_ACTIVATION"';
        $orders = json_decode(shell_exec($cmd), true);
    }
    //print_r($cmd);
    return $orders;
}

function get_filled_orders($access_token, $hashValue) {
    $orders = array();
    $from = date("Y-m-d", strtotime("-1 days"));
    $to = date("Y-m-d", strtotime("+1 days"));
    $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '/orders?fromEnteredTime=' . $from . 'T00%3A00%3A00.000Z&toEnteredTime=' . $to . 'T23%3A59%3A59.999Z&status=FILLED"';
    $orders = json_decode(shell_exec($cmd), true);

    //print_r($cmd);
    return $orders;
}

function get_quote($access_token, $ticker) {
    $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/marketdata/v1/' . $ticker . '/quotes?fields=quote%2Creference"';
    return json_decode(shell_exec($cmd), true);
}

function get_price_history($access_token, $ticker) {

    $current_timestamp_ms = round(microtime(true) * 1000);

    // Calculate one day in milliseconds
    $one_day_ms = 3 * 24 * 60 * 60 * 1000; // 86,400,000 milliseconds

    // Subtract one day to get the timestamp for exactly one day ago
    $one_day_ago = $current_timestamp_ms - $one_day_ms;

    //echo $one_day_ago_timestamp_ms;

    $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/marketdata/v1/pricehistory?symbol=' . $ticker . '&periodType=day&frequencyType=minute&needExtendedHoursData=true&needPreviousClose=true&startDate=1451541600000';
    return json_decode(shell_exec($cmd), true);
}

function get_options($access_token, $ticker) {
    $from = date("Y-m-d");
    $to = date("Y-m-d", strtotime("+5 days"));
    $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/marketdata/v1/chains?symbol=' . $ticker . '&strikeCount=32&includeUnderlyingQuote=true&fromDate=' . $from . '&toDate=' . $to . '"';
    return json_decode(shell_exec($cmd), true);
}

function get_trades($ticker, $hashValue, $access_token){

    // https://api.schwabapi.com/trader/v1/accounts/1233/transactions?startDate=2024-11-18T00%3A00%3A00.000Z&endDate=2024-11-18T23%3A59%3A59.999Z&symbol=SPY&types=TRADE
        print("trades for $ticker");

        $from = date("Y-m-d", strtotime("-1 month", now()));
        $to = date("Y-m-d");
        $cmd = 'curl -X GET --header "Accept: application/json" --header "Authorization: Bearer ' . urldecode($access_token) . '" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '/transactions?&startDate=' . $from . 'T00%3A00%3A00.000Z&endDate=' . $to . 'T23%3A59%3A59.999Z&symbol=' . $ticker . '&types=TRADE"';
        return json_decode(shell_exec($cmd), true);

}

function buy($token, $option, $price, $intraday, $hashValue){

            $ticker = $option;

            $putCall = (stristr(substr($ticker, -10), 'P') ) ? 'PUT' : 'CALL' ;
            
            $quantity = 1;
            //$price = "0.01";

            $option_payload = '{\"orderType\": \"MARKET\",\"session\": \"NORMAL\",\"duration\": \"DAY\",\"orderStrategyType\": \"SINGLE\",\"orderLegCollection\": [{\"instruction\": \"BUY_TO_OPEN\",\"quantity\": ' . $quantity . ',\"instrument\": {\"symbol\": \"' . $ticker . '\",\"assetType\": \"OPTION\"}}]}';

            if($intraday){
            
                $send_order = 'curl -X POST --header "Authorization: Bearer ' . $token . '" --header "Content-Type: application/json" -d "' . $option_payload . '" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '/orders"';
                $result = 0;
                print("<hr><b>Place Order:</b>");
                print("<br$send_order<br>$option_payload<br>");
                print("<hr>Response: ");

                //$result = shell_exec($send_order);

                print("<hr>" . $send_order . "<br>");
                
                print_r($result);

                if((trim($result) == '') || (trim($result) == '1')){
                    print("<br>Buy order successful!\n");
                    $db = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");
                    $sql = "INSERT INTO `log` (`ticker`, `action`, `payload`, `time`, `status`) VALUES ('" . $ticker . "', 'Buy order successful', '" . mysqli_escape_string($db, $option_payload) . "', now(), '1')";
                    $result = mysqli_query($db,$sql) or die('Error: ' . mysqli_error($db));

                }else{
                    print("<br>Buy order was not successful!\n");
                    print("Shell exec disabled.\n");

                    $sql = "INSERT INTO `log` (`ticker`, `action`, `payload`, `time`, `status`) VALUES ('" . $ticker . "', 'Buy order failed', '" . mysqli_escape_string($db, $option_payload) . "', now(), '1')";
                    $result = mysqli_query($db,$sql) or die('Error: ' . mysqli_error($db));
                }

            }else{
                print("Not intraday. Will not place BUY trade for " . $ticker . " @ " . date("Y-m-d H:i:s a") . "<hr>");
                $db = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");
                $sql = "INSERT INTO `log` (`ticker`, `action`, `payload`, `time`, `status`) VALUES ('" . $ticker . "', 'Not intraday - Buy', '" . mysqli_escape_string($db, $option_payload) . "', now(), '1')";
                $result = mysqli_query($db,$sql) or die('Error: ' . mysqli_error($db));
            }

            // else{
            //     $option_payload = '{\"orderType\": \"LIMIT\",\"session\": \"SEAMLESS\",\"duration\": \"GOOD_TILL_CANCEL\",\"orderStrategyType\": \"SINGLE\",\"price\": ' . $price . ',\"orderLegCollection\": [{\"instruction\": \"BUY_TO_OPEN\",\"quantity\": ' . $quantity . ',\"instrument\": {\"putCall\": \"' . $putCall . '\",\"symbol\": \"' . $ticker . '\",\"assetType\": \"OPTION\"}}]}';
            // }

}

function sell($token, $option, $price, $intraday, $hashValue){


            //$ticker = "SPY_091423P448";
            $ticker = $option;

            //$putCall = "PUT";
            $putCall = (stristr(substr($ticker, -10), 'P') ) ? 'PUT' : 'CALL' ;
            
            $quantity = 1;
            //$price = "0.01";

            $option_payload = '{\"orderType\": \"MARKET\",\"session\": \"NORMAL\",\"duration\": \"DAY\",\"orderStrategyType\": \"SINGLE\",\"orderLegCollection\": [{\"instruction\": \"SELL_TO_CLOSE\",\"quantity\": ' . $quantity . ',\"instrument\": {\"symbol\": \"' . $ticker . '\",\"assetType\": \"OPTION\"}}]}';

            if($intraday){
                
                
                    $send_order = 'curl -X POST --header "Authorization: Bearer ' . $token . '" --header "Content-Type: application/json" -d "' . $option_payload . '" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '/orders"';
                    $result = 0;
                    print("<hr><b>Place Order:</b>");
                    print("<br$send_order<br>$option_payload<br>");
                    print("<hr>Response: ");

                    //$result = shell_exec($send_order);

                    print("<hr>" . $send_order . "<br>");
                    
                    print_r($result);
                    $db = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");

                    if((trim($result) == '') || (trim($result) == '1')){
                        print("<br>Sell order successful!\n");
                        
                        $sql = "INSERT INTO `log` (`ticker`, `action`, `payload`, `time`, `status`) VALUES ('" . $ticker . "', 'Sell order successful', '" . mysqli_escape_string($db, $option_payload) . "', now(), '1')";
                        $result = mysqli_query($db,$sql) or die('Error: ' . mysqli_error($db));

                    }else{

                        print("<br>Sell order was not successful!\n");
                        print("Shell exec disabled.\n");

                        $sql = "INSERT INTO `log` (`ticker`, `action`, `payload`, `time`, `status`) VALUES ('" . $ticker . "', 'Sell order failed', '" . mysqli_escape_string($db, $option_payload) . "', now(), '1')";
                        $result = mysqli_query($db,$sql) or die('Error: ' . mysqli_error($db));
                    }

            }else{
                print("Not intraday. Will not place SELL trade for " . $ticker . " @ " . date("Y-m-d H:i:s a") . "<hr>");
                $db = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");
                $sql = "INSERT INTO `log` (`ticker`, `action`, `payload`, `time`, `status`) VALUES ('" . $ticker . "', 'Not intraday - Sell', '" . mysqli_escape_string($db, $option_payload) . "', now(), '1')";
                $result = mysqli_query($db,$sql) or die('Error: ' . mysqli_error($db));
                //$option_payload = '{\"orderType\": \"LIMIT\",\"session\": \"SEAMLESS\",\"duration\": \"GOOD_TILL_CANCEL\",\"orderStrategyType\": \"SINGLE\",\"price\": ' . $price . ',\"orderLegCollection\": [{\"instruction\": \"SELL_TO_CLOSE\",\"quantity\": ' . $quantity . ',\"instrument\": {\"putCall\": \"' . $putCall . '\",\"symbol\": \"' . $ticker . '\",\"assetType\": \"OPTION\"}}]}';
            }

}

function log_system($conn, $level, $message, $details = null) {
    $sql = "INSERT INTO system_log (log_level, message, details) VALUES (?, ?, ?)";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, 'sss', $level, $message, $details);
    mysqli_stmt_execute($stmt);
    
    if ($level == 'ERROR') {
        error_log("[$level] $message" . ($details ? " - $details" : ""));
    }
}

function writeStopPrice($price){
    $filename = 'stop_price.txt';
    file_put_contents($filename, $price);
}

function send_order($token, $ticker, $price, $session, $hashValue, $instruction){
            
            if($price < 10){
                return false;
            }

            // $tracked_orders = getTrackedOrders();
            // if (isset($tracked_orders[$price])) {
            //     echo "<br>Order already exists at $$price. Skipping duplicate.<br>";
            //     return null;
            // }

            // print("sending orders disabled for now.<br>");
            // return false;

            $quantity = 1;
            //$price = $price + .01;


            //if($session == "AM" || $session == "PM"){

                $order_payload = '{\"orderType\": \"LIMIT\",\"quantity\": ' . $quantity . ',\"price\": ' . $price . ',\"session\": \"SEAMLESS\",\"duration\": \"GOOD_TILL_CANCEL\",\"taxLotMethod\": \"FIFO\",\"orderStrategyType\": \"SINGLE\",\"orderLegCollection\": [{\"instruction\": \"' . $instruction . '\",\"quantity\": ' . $quantity . ',\"orderLegType\": \"EQUITY\",\"legId\": 0,\"instrument\": {\"symbol\": \"' . $ticker . '\",\"assetType\": \"EQUITY\"}}]}';

            // }elseif($session == "NORMAL"){

            //     $order_payload = '{\"orderType\": \"MARKET\",\"session\": \"' . $session . '\",\"duration\": \"DAY\",\"orderStrategyType\": \"SINGLE\",\"orderLegCollection\": [{\"instruction\": \"' . $instruction . '\",\"quantity\": ' . $quantity . ',\"instrument\": {\"symbol\": \"' . $ticker . '\",\"assetType\": \"EQUITY\"}}]}';

            // }

            $db = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");

            if($session == "AM" || $session == "PM" || $session == "NORMAL"){

                $send_order = 'curl -X POST --header "Authorization: Bearer ' . $token . '" --header "Content-Type: application/json" -d "' . $order_payload . '" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '/orders"';
                $result = 0;
                print("<hr><b>Place Order:</b>");
                print("<br$send_order<br>$order_payload<br>");
                print("<hr>Response: ");

                $result = shell_exec($send_order);

                print("<hr>" . $send_order . "<br>");
                
                print_r($result);

                if((trim($result) == '') || (trim($result) == '1')){
                    print("<br>$instruction order successful!\n");
                    
                    $sql = "INSERT INTO `log` (`ticker`, `action`, `payload`, `time`, `status`) VALUES ('" . $ticker . "', '$instruction order successful', '" . mysqli_escape_string($db, $order_payload) . "', now(), '1')";
                    $result = mysqli_query($db,$sql) or die('Error: ' . mysqli_error($db));

                }else{
                    print("<br>$instruction order was not successful!\n");
                    print("Shell exec disabled.\n");

                    $sql = "INSERT INTO `log` (`ticker`, `action`, `payload`, `time`, `status`) VALUES ('" . $ticker . "', '$instruction order failed', '" . mysqli_escape_string($db, $order_payload) . " - " . mysqli_escape_string($db, trim($result)) . "', now(), '1')";
                    $result = mysqli_query($db,$sql) or die('Error: ' . mysqli_error($db));
                }

            }else{

                print("Not within market hours.<br>Will not place BUY trade for " . $ticker . " @ " . date("Y-m-d H:i:s a") . "<hr>");
                deleteOrder($price, "WORKING");

                $db = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");
                $sql = "INSERT INTO `log` (`ticker`, `action`, `payload`, `time`, `status`) VALUES ('" . $ticker . "', 'Not intraday - $instruction', '" . mysqli_escape_string($db, $order_payload) . "', now(), '1')";
                $result = mysqli_query($db,$sql) or die('Error: ' . mysqli_error($db));
            }

            return true;
}

// function cancel_order($order_id) {
//     global $access_token, $hashValue;
//     // $url = "https://api.schwab.com/v1/accounts/{$hashValue}/orders/{$order_id}";
    
//     // $headers = ["Authorization: Bearer {$access_token}", "Content-Type: application/json"];
//     // $ch = curl_init();
//     // curl_setopt($ch, CURLOPT_URL, $url);
//     // curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
//     // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//     // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
//     // curl_exec($ch);
//     // curl_close($ch);

//     $send_order = 'curl -X DELETE --header "Authorization: Bearer ' . $access_token . '" --header "Accept: */*" --header "Content-Type: application/json" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '/orders/' . $order_id . '"';
//     $result = 0;
//     print("<hr><b>Canceling Order: $order_id</b>");
//     print("<br>$send_order<br>$order_payload<br>");
//     print("<hr>Response: ");

//     $result = shell_exec($send_order);

//     unset($_GET['cancel']);

//     return $result;

// }




function cancel_order($orderId) {
    global $hashValue, $access_token;
    $removeGet = 0;
    $url = "https://api.schwabapi.com/trader/v1/accounts/" . $hashValue . "/orders/" . $orderId;
    print($url."<hr>");
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE"); // Use DELETE method
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $access_token",
        "accept: */*" // This matches your expected headers
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    if ($httpCode !== 200) {
        echo "Failed to cancel order ID $orderId: HTTP Code $httpCode\n";
        echo "Response: $response\n";
        echo "cURL Error: $error\n";
    } else {
        echo "Successfully canceled order ID $orderId\n";
        $removeGet = 1;
    }
    print("<hr>");
    return $removeGet;

}


function hasOpenPositions($positions) {
    foreach ($positions as $position) {
        if (strpos($position['instrument']['symbol'], 'SPY') !== false) {
            return true;
        }
    }
    return false;
}

print(date("M d, Y H:i:s a") . "<br>");

    $currentTime = strtotime(date("YmdHis"));
    $refresh_timer = "30000";
    $date_offset = 0;
    $intraday = 0;
    $dayOfWeek = date("w");

    if ($dayOfWeek == '0' || $dayOfWeek == '6') {
        $refresh_timer = "360000";
        echo "Weekend. Market closed.";
    } else {

        $startTime = strtotime('07:00');
        $intradayStartTime = strtotime('09:30');
        $intradayEndTime = strtotime('16:00');
        $eveningStartTime = strtotime('16:00');
        $endTime = strtotime('20:00');

        if ($currentTime >= $startTime && $currentTime < $intradayStartTime) {
            $refresh_timer = "5000";
            $session = "AM";
        } elseif ($currentTime >= $intradayStartTime && $currentTime < $intradayEndTime) {
            $refresh_timer = "5000";
            $session = "NORMAL";
            $intraday = "1";
        } elseif ($currentTime >= $eveningStartTime && $currentTime <= $endTime) {
            $refresh_timer = "5000";
            $session = "PM";
        } else {
            $refresh_timer = "30000";
            $session = "CLOSED";
        }

        if ($intraday == 1) {
            echo "Intraday. Market orders enabled.";
        } else {
            echo "Not intraday. Market orders disabled.";
        }
        //$refresh_timer = $marketOpen['refresh_timer'];
    }

    //print("<br>AM: $startTime - Normal: $intradayStartTime - PM: $eveningStartTime - End: $endTime<br>");

    $date_offset = calculate_date_offset($dayOfWeek);
    $tomorrow_offset = $date_offset + 1;

    echo " - Refresh Timer: " . $refresh_timer;
    if ($date_offset) {
        echo " - " . "Date Offset: " . $date_offset;
    }

$profit_target = isset($_GET['target']) ? $_GET['target'] : '1';
$stop = isset($_GET['stop']) ? $_GET['stop'] : '1';

$ticker = isset($_GET['ticker']) ? strtoupper($_GET['ticker']) : 'SPY';
$cash = isset($_GET['cash']) ? $_GET['cash'] : '500';
$access_token = trim(file_get_contents("./access_token.txt"));

$db = new mysqli("localhost", "root", "", "quotes") or die("Database Connection Failed");

$accounts = array();
$accounts = get_account_numbers($access_token);
if(is_array($accounts) && !array_key_exists('0', $accounts)){
    $access_token = update_token();
    echo "Updated token.\n";
    echo "<script>setTimeout(function(){window.location.reload(1);}, 100);</script>";
    exit;
}
$accountNumber = $accounts[0]['accountNumber'];
$hashValue = $accounts[0]['hashValue'];
file_put_contents("./hashValue.txt", $hashValue);
echo "<br>accountNumber: " . $accountNumber . "<br>";
//echo "hashValue: " . $hashValue . "<br>";

$account = get_account_data($access_token, $hashValue);

include("create_table.php");
$mysqli = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");
createTableFromArray($accounts, 'accounts', $mysqli);

$cashAvailableForTrading = $account['securitiesAccount']['currentBalances']['cashAvailableForTrading'];
$cashAvailableForWithdrawal = $account['securitiesAccount']['currentBalances']['cashAvailableForWithdrawal'];

// $cashAvailableForTrading = $account['securitiesAccount']['currentBalances']['availableFundsNonMarginableTrade'];
// $cashAvailableForWithdrawal = $account['securitiesAccount']['currentBalances']['liquidationValue'];

//echo "cashAvailableForTrading: " . $cashAvailableForTrading . " - ";
//echo "cashAvailableForWithdrawal: " . $cashAvailableForWithdrawal . "<br>";

// CHECK TRADE LIMIT
$max_trades = "250"; // $5/day in fees for 1000 log (.01 per round trip x 500 round trips)

$mysqli = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");

// $sql = "SELECT count(*) as total from log where DATE(time) = CURDATE() and action not like '%intraday%' and action not like '%failed%'";

// $result = mysqli_query($mysqli, $sql) or die("Error in SQL query: " . mysqli_error($mysqli));

// if ($row = mysqli_fetch_assoc($result)) {
//     // Access the row count
//     echo "Total trades: " . $row['total'];
//     $total_trades = $row['total'];
//     if($total_trades >= $max_trades){
//         print("<br>Max trades reached. (" . $total_trades . " / " . $max_trades . ") ");
//         //exit;
//     }
// } else {
//     echo "No trades found.";
// }
// END CHECK TRADE LIMIT

$open_orders = array();
$open_orders = get_orders($access_token, $hashValue);
if (is_array($open_orders) && array_key_exists('errors', $open_orders)) {
    $access_token = update_token();
    echo "Updated token.\n";
    echo "<script>setTimeout(function(){window.location.reload(1);}, 100);</script>";
    exit;
}

$filled_orders = array();
$filled_orders = get_filled_orders($access_token, $hashValue);

print("<hr>spybot v1");

function capitalRequiredForDrawdowns($initialPrice) {
    // Define the drawdowns you care about
    $drawdownLevels = [
        0.10,  // 10%
        0.25,  // 25%
        0.50,  // 50%
        0.75,  // 75%
        1.00,  // 100%
    ];

    foreach ($drawdownLevels as $drawdown) {
        // Calculate final price after this drawdown
        $finalPrice = $initialPrice * (1 - $drawdown);

        // Number of whole-dollar drops
        // e.g. if price = 125 and finalPrice = 112.5 => floor(125 - 112.5) = 12
        $numDrops = (int) floor($initialPrice - $finalPrice);

        // Capital required: sum of buying 1 share at each integer down:
        // i.e. buy at (initialPrice - 1), (initialPrice - 2), ..., (initialPrice - numDrops)
        // That sum can be computed by the arithmetic-series formula:
        //   sum_{k=1 to N} (P - k) = N * P - (N*(N+1))/2

        $capital = $numDrops * $initialPrice - ($numDrops * ($numDrops + 1)) / 2;

        echo sprintf(
            "%3d%% drop (from \$%.2f down to \$%.2f): Buy %d shares, Capital Required Per Share = \$%.2f\n",
            $drawdown * 100,
            $initialPrice,
            $finalPrice,
            $numDrops,
            $capital
        );
    }
}

// $sql = "TRUNCATE open_orders_old";
// $result = mysqli_query($mysqli, $sql) or die("Error in SQL query: " . mysqli_error($mysqli));

// $sql = "insert into open_orders_old select * from open_orders";
// $result = mysqli_query($mysqli, $sql) or die("Error in SQL query: " . mysqli_error($mysqli));

// $sql = "TRUNCATE open_orders_orderlegcollection_old";
// $result = mysqli_query($mysqli, $sql) or die("Error in SQL query: " . mysqli_error($mysqli));

// $sql = "insert into open_orders_orderlegcollection_old select * from open_orders_orderlegcollection";
// $result = mysqli_query($mysqli, $sql) or die("Error in SQL query: " . mysqli_error($mysqli));

// $sql = "TRUNCATE open_orders";
// $result = mysqli_query($mysqli, $sql) or die("Error in SQL query: " . mysqli_error($mysqli));

// $sql = "TRUNCATE open_orders_orderlegcollection";
// $result = mysqli_query($mysqli, $sql) or die("Error in SQL query: " . mysqli_error($mysqli));


$pending_orders = array();
//print_r($open_orders);
$buy_orders = 0;
$buy_to_cover_orders = 0;
$sell_orders = 0;
$sell_short_orders = 0;
if (is_array($open_orders) && array_key_exists('0', $open_orders)) {
    echo "<hr>Open Orders<br>";
    //createTableFromArray($open_orders, 'open_orders', $mysqli);
    foreach ($open_orders as $key => $value) {
        if($value['orderLegCollection']['0']['instrument']['symbol'] == 'SPY'){

            print($value['orderType'] . " - " . $value['orderLegCollection']['0']['instrument']['symbol'] . " - " . $value['quantity'] . " - " . $value['orderLegCollection']['0']['instruction'] . " @ $" . $value['price'] . " - " . $value['status'] . " - " . $value['orderId'] . " - " . $value['enteredTime'] . " - <a href='?cancel=" . $value['orderId'] . "'>cancel</a><br>");

            if(array_key_exists('cancel', $_GET) && ($_GET['cancel'] == $value['orderId'])){
                cancel_order($value['orderId']);
            }

            // if($value['status'] == 'PENDING_ACTIVATION'){
            //     cancel_order($value['orderId']);
            // }


            if($value['order_type'] == 'BUY'){
                $buy_orders = $buy_orders + 1;
                $buy_order_id = $value['orderId'];
            }elseif($value['order_type'] == 'BUY_TO_COVER'){
                $buy_to_cover_orders = $buy_to_cover_orders + 1;
                $buy_to_cover_order_id = $value['orderId'];
            }elseif($value['order_type'] == 'SELL'){
                $sell_orders = $sell_orders + 1;
                $sell_order_id = $value['orderId'];
            }elseif($value['order_type'] == 'SELL_SHORT'){
                $sell_short_orders = $sell_short_orders + 1;
                $sell_short_order_id = $value['orderId'];
            }

            $pending_orders[] = $value['orderLegCollection']['0']['instrument']['symbol'];

            if($value['orderLegCollection']['0']['instruction'] == 'BUY'){
                $buys[$value['price']] = $value['orderId'];
            }elseif($value['orderLegCollection']['0']['instruction'] == 'SELL'){
                $sells[$value['price']] = $value['orderId'];
            }


        }

    }
}


// $sql = "SELECT price, instruction, orderID from open_orders_old join open_orders_orderlegcollection on open_orders_old.id = open_orders_orderlegcollection.open_orders_id where price not in (select price from open_orders)";

// $result = mysqli_query($mysqli, $sql) or die("Error in SQL query: " . mysqli_error($mysqli));
// if (!empty($result)) {

//     $sql2 = "insert into fills(orderID, quantity, price, instruction, enteredTime) SELECT orderID, open_orders_old.quantity, open_orders_old.price, instruction, enteredTime from open_orders_old join open_orders_orderlegcollection_old on open_orders_old.id = open_orders_orderlegcollection_old.open_orders_id where price not in (select price from open_orders)";

//     $result2 = mysqli_query($mysqli, $sql2) or die("Error in SQL query: " . mysqli_error($mysqli));

//         while($row = mysqli_fetch_assoc($result)) {


//                 print("<br>" . $instruction . " order removed at " . $row['price'] . " - Order ID: " . $row['orderID']);

//                 print("Filled? " . checkOrderFilled($row['orderID']));

//         }
        
//     }else {
//     echo "No log found.";
// }



// $sql = "SELECT instruction, price, orderID from fills";

// $result = mysqli_query($mysqli, $sql) or die("Error in SQL query: " . mysqli_error($mysqli));
// if (!empty($result)) {
// //print("<br>Fills:");
//         while($row = mysqli_fetch_assoc($result)) {

//                 print("<br>Filled " . $row['instruction'] . "  at " . $row['price'] . " - Order ID: " . $row['orderID']);

//         }
        
//     }else {
//     //echo "No fills found.";
// }


$positions = array();
$positions = get_positions($access_token, $hashValue);

        $open_call =array();
        $open_put = array();
        $call_to_close = "";
        $put_to_close ="";

//print_r($positions);
if (is_array($positions['0']['securitiesAccount']) && array_key_exists('positions', $positions['0']['securitiesAccount'])) {
    echo "<hr>Positions<br>";
    //createTableFromArray($positions, 'positions', $mysqli);
    foreach ($positions['0']['securitiesAccount']['positions'] as $key => $value) {

        if($value['instrument']['symbol'] == 'SPY'){

            $qty = ($value['longQuantity']) ? $value['longQuantity'] : "-" . $value['shortQuantity'];

            print($value['instrument']['assetType'] . " - " . $qty . " - " . $value['instrument']['symbol'] . " @ $" . $value['averagePrice'] . " - $" . $value['marketValue'] . " - " . $value['instrument']['description'] . "<br>");


              if((stristr($value['instrument']['symbol'], 'SPY') && $value['longQuantity'] >= '1')){

                $call_to_close = $value['instrument']['symbol'];
                $open_call['symbol'] = $value['instrument']['symbol'];
                $open_call[$value['instrument']['symbol']]['avg_price'] =  $value['averagePrice'];
                $open_call[$value['instrument']['symbol']]['type'] =  'CALL';
                $open_call[$value['instrument']['symbol']]['strategy'] =  'strangle';

            }elseif((stristr($value['instrument']['symbol'], 'SPY') && $value['shortQuantity'] >= '1')){

                $put_to_close = $value['instrument']['symbol'];
                $open_put['symbol'] = $put_to_close;
                $open_put[$value['instrument']['symbol']]['avg_price'] =  $value['averagePrice'];
                $open_put[$value['instrument']['symbol']]['type'] =  'PUT';
                $open_put[$value['instrument']['symbol']]['strategy'] =  'strangle';

            }
        }
        
    }

    if($call_to_close){
        print("Long to close: ".$call_to_close ." (" . $value['longQuantity'] . ")<br>");
    }elseif($put_to_close){
        print("Short to close: ".$put_to_close ." (" . $value['shortQuantity'] . ")<br>");
    }
    

}

$quote = get_quote($access_token, $ticker);
// echo "<hr>Quote<hr>";
// print_r($quote);
$mysqli = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");
$result = createTableFromArray($quote, 'quote', $mysqli);
//echo "<hr>Updated quote<hr>";

// output new quote file for interface
$bid = $quote['SPY']['quote']['bidPrice'];
$ask = $quote['SPY']['quote']['askPrice'];
$last = $quote['SPY']['quote']['mark'];
$bidSize = $quote['SPY']['quote']['bidSize'];
$askSize = $quote['SPY']['quote']['askSize'];
//$entry = round(($bid+$ask)/2,2)+.02;
$long_entry = min($last, $ask) + .01;
$short_entry = max($last, $bid) - .01;
$spread = $ask - $bid;
// $long_stop = $bid - ($spread + .01);
// $short_stop = $ask + ($spread + .01);
$long_stop = $bid - .35;
$short_stop = $ask + .35;

if($call_to_close){
    $position = "LONG";
    $entry = $open_call[$call_to_close]['avg_price'];
}elseif ($put_to_close) {
    $position = "SHORT";
    $entry = $open_put[$put_to_close]['avg_price'];
}else{
    $position = "OUT";
}

print("<hr>SPY Mark: " . $quote['SPY']['quote']['mark'] . "<br>");
print("SPY Bid/Ask: " . $bid . " (" . $bidSize . ") / " . $ask . " (" . $askSize . ")<br>");
print("SPY Open/Low/High: " . $quote['SPY']['quote']['openPrice'] . " / " . $quote['SPY']['quote']['lowPrice'] . " / " . $quote['SPY']['quote']['highPrice'] . "<br>");
print("SPY Volume: " . number_format($quote['SPY']['quote']['totalVolume']));
//print($options['symbol'] . " Contracts: " . number_format($options['numberOfContracts']) . "<hr>");
print("<hr>");
capitalRequiredForDrawdowns($last);
// LADDER TRADING SYSTEM

// SELECT sum(quantity), sum(entry_price), (sum(entry_price*quantity)/sum(quantity)) FROM `log` where status = 'OPEN';
// SELECT sum(quantity), sum(entry_price), (sum(entry_price*quantity)/sum(quantity)) FROM `log` where status = 'OPEN' and log.entry_order_filled is not null;

// print("<hr>");
// print("Ladder Bot: On");
// print("<hr>");

// User-defined Increment Options: Choose 1, 0.5, 0.25, or 0.1
// $valid_intervals = [1.00, 0.50, 0.25, 0.10];
// $user_defined_interval = 1; // Change this value as needed
// $interval = $user_defined_interval;

// if (!in_array($user_defined_interval, $valid_intervals)) {
//     die("Invalid interval. Choose from 1, 0.5, 0.25, or 0.1.");
// }


function getTrackedOrders() {
    global $mysqli;
    $orders = [];

    $result = mysqli_query($mysqli, "SELECT * FROM trade_orders WHERE status = 'WORKING' and type='buy'");
    while ($row = mysqli_fetch_assoc($result)) {
        $orders[round($row['level'])] = [
            'type' => $row['type'],
            'order_id' => $row['order_id'],
            'action' => $row['action']
        ];
    }
    return $orders;
}

// Log Orders in MySQL
//("BUY", $buy_level, $symbol, $buy_level, $order['order_id'], "BUY", "WORKING");
function logTrade($action, $price, $symbol, $level, $order_id, $type, $status) {
    global $mysqli;

    $sql = "INSERT INTO trade_orders (action, price, symbol, level, order_id, type, status) VALUES ('$action', '$price','$symbol', '$level', '$order_id', '$type', '$status')";
    if (!mysqli_query($mysqli, $sql)) {
        echo "Error logging trade: " . mysqli_error($mysqli) . "\n";
    }else{
        //echo "logged trade.<br>";
    }
}

function updateOrderStatus($level, $status) {
    global $mysqli;
    $sql = "UPDATE trade_orders SET status = '$status' WHERE level = '$level' and type = 'BUY'";
    //$sql = "DELETE from trade_orders where level = '$level' and status = 'WORKING'";
    mysqli_query($mysqli, $sql);
}

function updateOrderID($level, $status) {
    global $mysqli;
    $sql = "UPDATE trade_orders SET status = '$status' WHERE level = '$level' and status = 'WORKING'";
    mysqli_query($mysqli, $sql);
}

function deleteOrder($level, $status) {
    global $mysqli;
    $sql = "DELETE from trade_orders where level = '$level' and status = '$status'";
    //print("<br>".$sql."<br>");
    mysqli_query($mysqli, $sql);
}

function deleteAllOrders() {
    global $mysqli;
    $sql = "DELETE from trade_orders";
    //print("<br>".$sql."<br>");
    mysqli_query($mysqli, $sql);
}

// Check If a Schwab Order is FILLED
function checkOrderFilled($order_id) {
    global $access_token, $hashValue;

    if($order_id){
        $send_order = 'curl -X POST --header "Authorization: Bearer ' . $access_token . '" --header "Content-Type: application/json" "https://api.schwabapi.com/trader/v1/accounts/' . $hashValue . '/orders/' . $order_id . '"';
        $result = 0;
        print("<hr>Checking if order $order_id is filled.</b>");
                    //print("<br$send_order<br>$order_payload<br>");

        //$result = shell_exec($send_order);
        print_r($result);
        $data = json_decode($result, true);
        return isset($data['status']) && strtoupper($data['status']) == "FILLED";
    }else{
        return false;
    }
    
}


$host = "localhost";
$user = "root";
$pass = "";
$db   = "spybot";

$conn = mysqli_connect($host, $user, $pass, $db);
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// ---------------------------------------------------------------------------
// 2. Configuration and "Constants"
// ---------------------------------------------------------------------------
$SCHWAB_CLIENT_ID     = 'bOGMvBTAXhmi0zG5QqGQhowEwDNMZujB';
$SCHWAB_CLIENT_SECRET = 'YOUR_SCHWAB_CLIENT_SECRET';
$SCHWAB_ACCOUNT_ID    = $hashValue;
$SCHWAB_OAUTH_URL        = 'https://api.schwab.com/v1/oauth/token';
$SCHWAB_QUOTE_URL        = 'https://api.schwab.com/v1/marketdata/quotes';
$SCHWAB_ORDERS_URL       = 'https://api.schwabapi.com/trader/v1/accounts/{accountId}/orders';
$SCHWAB_SINGLE_ORDER_URL = 'https://api.schwabapi.com/trader/v1/accounts/{accountId}/orders/{orderId}';

// Strategy defaults
$bias           = isset($_GET['bias']) ? $_GET['bias'] : 'long';
$priceIncrement = isset($_GET['increment']) ? (float)$_GET['increment'] : 1.00;
$symbol         = "SPY";
$fixedQuantity  = 1;

$TOKEN_STORAGE_FILE = __DIR__ . '/schwab_oauth_token.json';

function placeSchwabOrder($accountId, $symbol, $side, $orderType, $quantity, $price, $accessToken) {
    global $SCHWAB_ORDERS_URL;

    $orderPayload = [
        "orderType" => $orderType,
        "quantity" => (int)$quantity,  // Ensure integer format
        "session" => "SEAMLESS",
        "duration" => "GOOD_TILL_CANCEL",
        "taxLotMethod" => "FIFO",
        "orderStrategyType" => "SINGLE",
        "price" => $price,
        "orderLegCollection" => [
            [
                "instruction" => $side,
                "quantity" => (int)$quantity,
                "orderLegType" => "EQUITY",
                "legId" => 0,
                "instrument" => [
                    "symbol" => $symbol,
                    "assetType" => "EQUITY"
                ]
            ]
        ]


    ];


    echo json_encode($orderPayload, JSON_PRETTY_PRINT);
    print("<hr>");

    // Replace {accountId} in the URL
    $url = str_replace('{accountId}', urlencode($accountId), $SCHWAB_ORDERS_URL);
    print("<br>" . $url . "<br>");
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $accessToken",
        "Content-Type: application/json"
    ]);
    //curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($orderPayload));
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($orderPayload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if (curl_errno($ch)) {
        print("Order placement error: " . curl_error($ch));
    }else{
        //print("Response: " . $response . "<br>");
    }
    curl_close($ch);

    if($httpCode == '201'){
        print("Order successfully placed.<br>");
    }elseif($httpCode == '400'){
        print("Validation problem with the request.<br>");
    }elseif($httpCode == '401'){
        print("Authorization token is invalid<br>");
    }elseif($httpCode == '403'){
        print("Caller is forbidden from accessing this service.<br>");
    }elseif($httpCode == '404'){
        print("Resource not found.<br>");
    }elseif($httpCode == '500'){
        print("Unexpected server error<br>");
    }

    $data = json_decode($response, true);
    // if (!isset($data['orderId'])) {
    //     print_r($data);
    //     print("<hr>");
    //     print("Failed to place order: " . $response);
    // }

    return $httpCode; // Return broker-generated order ID
}

function checkSchwabOrderStatus($accountId, $orderId, $accessToken) {
    global $SCHWAB_SINGLE_ORDER_URL;

    if($orderId == '201' || $orderId == '400' || $orderId == '401' || $orderId == '403' || $orderId == '404' || $orderId == '500'){
        return false;
    }
    $url = str_replace('{accountId}', urlencode($accountId), $SCHWAB_SINGLE_ORDER_URL);
    $url = str_replace('{orderId}', urlencode($orderId), $url);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $accessToken"
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //print("<br>");
    $response = curl_exec($ch);


    $data = json_decode($response, true);

    $order_id = $data['orderId'];
    $instruction = $data['orderLegCollection'][0]['instruction'];

    print("Checking " . $instruction . " order status: " . $order_id . " is " . $data['status'] . "<br>");

    if (curl_errno($ch)) {
        print("Order status check error: " . curl_error($ch));
    }
    curl_close($ch);

    if (!isset($data['status'])) {
        print("Could not parse order status: " . $response);
    }

    return $data;
}

function update_open_orders($hashValue,$access_token){
    global $symbol, $mysqli, $buys;

    $sql = "SELECT *
        FROM log
        WHERE symbol = '$symbol'
          AND status = 'OPEN' and schwab_order_id = '201' LIMIT 1";
    $result = mysqli_query($mysqli, $sql) or die(mysqli_error($mysqli));
    $row = mysqli_fetch_assoc($result);
    //print("<hr>" . $sql . "<hr>");
    if (!$row) {
        //print("<hr>No orders to update<hr>");
    }else{
        //$row = mysqli_fetch_assoc($result);
        print("<hr>");
        print_r($row);
        print("<hr>");
        $trade_id = $row['trade_id'];
        print("trade id: " . $trade_id . "<br>");
    
        $entry_price = $row['entry_price'];
        $exit_price = $row['exit_price'];

        if(is_array($buys)){
            if(array_key_exists(number_format($entry_price, 0), $buys)){
            $entry_order_id = $buys[number_format($entry_price, 0)];
        }
        
        }

        
        if($entry_order_id){

            $sql = "update log set schwab_order_id = '" . $entry_order_id . "' where trade_id = '" . $trade_id . "'";
            $result = mysqli_query($mysqli, $sql);

            print("<hr>Found entry order ID " . $entry_order_id . " for trade_id " . $trade_id . "<br>");


        }else{

            $now = new DateTime("now", new DateTimeZone("UTC"));

            // Get time 10 seconds ago
            $fromTime = clone $now;
            $fromTime->modify("-2 minutes");

            // Get time 10 seconds from now
            $toTime = clone $now;
            //$toTime->modify("+10 seconds");

            // Format times in ISO 8601 format (compatible with Schwab API)
            $fromTimeFormatted = urlencode($fromTime->format("Y-m-d\TH:i:s.u\Z"));
            $toTimeFormatted = urlencode($toTime->format("Y-m-d\TH:i:s.u\Z"));

            // Construct the API URL
            $url = "https://api.schwabapi.com/trader/v1/accounts/" . $hashValue . "/orders?maxResults=1&fromEnteredTime=$fromTimeFormatted&toEnteredTime=$toTimeFormatted";

            // Output URL (for debugging)
            //echo $url . "<br>";

            //$url = "https://api.schwabapi.com/trader/v1/accounts/" . $hashValue . "/orders?maxResults=10&fromEnteredTime=2025-02-20T20%3A00%3A00.000Z&toEnteredTime=2025-02-22T02%3A00%3A00.000Z";

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "Authorization: Bearer $access_token",
                "Accept: application/json"
            ]);

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            // echo "HTTP Code: $httpCode\n";
            // echo "Response: $response\n";
            // echo "JSON: ";


            if(stristr($response, '"instruction":"BUY"')){
                $field = "schwab_order_id";
            }elseif(stristr($response, '"instruction":"SELL"')){
                $field = "schwab_exit_order_id";
            }

            $response = json_decode($response, TRUE);
            print($response);

            $entry_order_id = $response[0]['orderId'];

            print("<hr>Schwab returned order ID " . $entry_order_id . " for trade_id " . $trade_id . "<br>");

            if($entry_order_id && $field && $trade_id){

                $sql = "update log set " . $field . " = '" . $entry_order_id . "' where trade_id = '" . $trade_id . "'";
                $result = mysqli_query($mysqli, $sql);
                if($result){
                    print("successfully updated order id - " . $sql);
                }else{
                    print("error updating order id - " . $sql);
                }

            }else{
                    print("field or order ID missing - " . $sql);
                }

            print("<hr>");
        }
    }
    
}

function update_exit_orders($hashValue,$access_token){
    global $symbol, $mysqli, $sells;

    $sql = "SELECT *
        FROM log
        WHERE symbol = '$symbol'
          AND status = 'OPEN' and schwab_exit_order_id = '201' LIMIT 1";
    $result = mysqli_query($mysqli, $sql);
    $row = mysqli_fetch_assoc($result);
    //print("<hr>" . $sql . "<hr>");
    if (!$row) {
        print("<hr>No orders to update<hr>");
    }else{
        //$row = mysqli_fetch_assoc($result);
        print("<hr>");
        print_r($row);
        print("<hr>");
        $trade_id = $row['trade_id'];
        print("trade id: " . $trade_id . "<br>");

        //$entry_price = $row['entry_price'];
        $exit_price = $row['exit_price'];

        if(array_key_exists(number_format($exit_price, 0), $sells)){
            $exit_order_id = $sells[number_format($exit_price, 0)];
        }
        
        if($exit_order_id){

            $sql = "update log set schwab_exit_order_id = '" . $exit_order_id . "' where trade_id = '" . $trade_id . "'";
            $result = mysqli_query($mysqli, $sql);

            print("<hr>Found exit order ID " . $entry_order_id . " for trade_id " . $trade_id . "<br>");


        }else{

            $now = new DateTime("now", new DateTimeZone("UTC"));

            // Get time 10 seconds ago
            $fromTime = clone $now;
            $fromTime->modify("-10 hours");

            // Get time 10 seconds from now
            $toTime = clone $now;
            //$toTime->modify("+10 seconds");

            // Format times in ISO 8601 format (compatible with Schwab API)
            $fromTimeFormatted = urlencode($fromTime->format("Y-m-d\TH:i:s.u\Z"));
            $toTimeFormatted = urlencode($toTime->format("Y-m-d\TH:i:s.u\Z"));

            // Construct the API URL
            $url = "https://api.schwabapi.com/trader/v1/accounts/" . $hashValue . "/orders?maxResults=1&fromEnteredTime=$fromTimeFormatted&toEnteredTime=$toTimeFormatted";

            // Output URL (for debugging)
            //echo $url . "<br>";

            //$url = "https://api.schwabapi.com/trader/v1/accounts/" . $hashValue . "/orders?maxResults=10&fromEnteredTime=2025-02-20T20%3A00%3A00.000Z&toEnteredTime=2025-02-22T02%3A00%3A00.000Z";

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "Authorization: Bearer $access_token",
                "Accept: application/json"
            ]);

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            echo "HTTP Code: $httpCode\n";
            echo "Response: $response\n";
            // echo "JSON: ";

            $field = "schwab_exit_order_id";

            $response = json_decode($response, TRUE);
            print($response);

            $exit_order_id = $response[0]['orderId'];

            print("<hr>Schwab returned order ID '" . $exit_order_id . "' for trade_id " . $trade_id . "<br>");

            if($exit_order_id){

                $sql = "update log set schwab_exit_order_id = '" . $exit_order_id . "' where trade_id = '" . $trade_id . "'";
                $result = mysqli_query($mysqli, $sql);
                if($result){
                    print("successfully updated order id - " . $sql);
                }else{
                    print("error updating order id - " . $sql);
                }

            }else{
                    print("could not update exit order. order ID missing - " . $sql);
            }

            print("<hr>");

        }

        
    }

    return $exit_order_id;
    
}


// START LOGIC

// check current level  // LOAD TRADED LEVELS
// $base = floor($last)
// $sell = $base + 1;
// // check open orders for buys and sells
// if (!$base){
//     //enter base
// }else{
//     check_buy_status();
//     if($status == "WORKING" || $status == "PENDING_ACTIVATION"){
//         // do nothing
//     }elseif($status == "CANCELLED"){
//         // reenter order
//     }elseif($status == "FILLED"){
//         check_sell_status();
//         if($sell_status == "WORKING" || $sell_status == "PENDING_ACTIVATION"){
//             // do nothing
//         }elseif($sell_status == "CANCELLED"){
//             // reenter order
//         }elseif($sell_status == "FILLED"){
//             //close trade
            
//         }
//     }
// }

// END LOGIC

update_open_orders($hashValue,$access_token);

$accessToken  = $access_token;
$currentPrice = $last;

$symbolEsc = mysqli_real_escape_string($conn, $symbol);
$biasEsc   = mysqli_real_escape_string($conn, $bias);
$sqlOpen = "SELECT * FROM log WHERE symbol = '$symbolEsc' AND bias = '$biasEsc' AND status = 'OPEN'";
$resOpen = mysqli_query($conn, $sqlOpen);

// LOAD TRADED LEVELS
$openTrades = [];
$tradedLevels = [];
while ($row = mysqli_fetch_assoc($resOpen)) {
    $openTrades[] = $row;
    $tradedLevels[] = (int) floor($row['entry_price']); 
    // For a short, we could also store ceil(...) for simplicity, we do floor() for both.
}

// SHOULD TRADE?
$shouldAddTrade = false;
$newTradeLevel  = null;

if ($bias === 'long') {

    $roundedFloor = floor($currentPrice);
    // If the market is >= that floor + 0.01 and we haven't traded it, open a new position
    if (($currentPrice >= $roundedFloor + .01) && !in_array($roundedFloor, $tradedLevels)){
        $shouldAddTrade = true;
        $newTradeLevel  = $roundedFloor;
    }

} else {

    $roundedCeil = ceil($currentPrice);
    if (
        ($currentPrice <= $roundedCeil - .01) &&
        !in_array($roundedCeil, $tradedLevels)
    ) {
        $shouldAddTrade = true;
        $newTradeLevel  = $roundedCeil;
    }
}

if ($shouldAddTrade && !is_null($newTradeLevel)) {

    if ($bias === 'long') {
        $desiredEntryPrice = (float) $newTradeLevel;   // e.g., 139.00
        $side = 'BUY';
        $profitExitPrice = $desiredEntryPrice + $priceIncrement;
    } else {
        $desiredEntryPrice = (float) $newTradeLevel;   // e.g., 140.00 if ceil(139.87) is 140
        $side = 'SELL';
        $profitExitPrice = $desiredEntryPrice - $priceIncrement;
    }

    // ADD BUY TO OPEN
    $entryOrderId = placeSchwabOrder(
        $hashValue,
        $symbol,
        $side,
        'LIMIT',
        $fixedQuantity,
        $desiredEntryPrice,
        $access_token
    );


    $qSymbol       = mysqli_real_escape_string($conn, $symbol);
    $qBias         = mysqli_real_escape_string($conn, $bias);
    $qEntryPrice   = $desiredEntryPrice;
    $qQuantity     = (int)$fixedQuantity;
    $qEntryOrderId = mysqli_real_escape_string($conn, $entryOrderId);
    $qExitPrice    = $profitExitPrice;

    // LOG BUY TO OPEN
    $insertSql = "INSERT INTO log (symbol, bias, entry_price, entry_order_entered, exit_price, quantity, schwab_order_id, status) VALUES ('$qSymbol', '$qBias', $qEntryPrice, now(), $qExitPrice, $qQuantity, '$qEntryOrderId', 'OPEN')";
    mysqli_query($conn, $insertSql);

    // Do NOT place the exit order now.
}

// CHECK FILLS
$current_level = floor($currentPrice);
$sqlCheckFills = "SELECT * FROM log WHERE symbol = '$symbolEsc' AND status = 'OPEN' and entry_price = '" . $current_level . "' LIMIT 1";
$resCheckFills = mysqli_query($conn, $sqlCheckFills);

//print($sqlCheckFills . "<br>");

while ($trade = mysqli_fetch_assoc($resCheckFills)) {
    $tradeId      = $trade['trade_id'];
    $entryOrderId = trim(str_replace('+', '', $trade['schwab_order_id']));
    $exitOrderId  = trim(str_replace('+', '', $trade['schwab_exit_order_id']));  // might be NULL if not placed yet
    $desiredExit  = (float)$trade['exit_price'];
    $biasDb       = $trade['bias'];

    print("<hr>Managing level $" . $current_level . "<br>");

    if ($exitOrderId) {
        print("Exit order " . $exitOrderId . " found.<br>");
        if(trim($exitOrderId) == '201'){
            print("Getting exit order ID<br>");
            $exitOrderId = update_exit_orders($hashValue,$access_token);
        }
        //print("Checking order status for " . $exitOrderId . "<br>");
        $exitStatusData = checkSchwabOrderStatus($hashValue, $exitOrderId, $access_token);
        $exitStatus     = $exitStatusData['status'];

        if ($exitStatus === 'FILLED') {

            $updateSql = "UPDATE log SET exit_order_filled = now(), status = 'CLOSED' WHERE trade_id = '" . $tradeId . "'";
            mysqli_query($conn, $updateSql);
            print($updateSql . "<br>");

        } elseif ($exitStatus === 'CANCELED' || $exitStatus === 'REJECTED') {
                
                // Reenter the exit order
                if ($biasDb === 'long') {
                    $exitSide = 'SELL';
                } else {
                    $exitSide = 'BUY';
                }

                $newExitOrderId = placeSchwabOrder(
                    $hashValue,
                    $trade['symbol'],
                    $exitSide,
                    'LIMIT',
                    $trade['quantity'],
                    $desiredExit,
                    $accessToken
                );
                // Update DB

                $qNewExitOrderId = mysqli_real_escape_string($conn, $newExitOrderId);
                $sqlUpdExit = "UPDATE log SET exit_order_entered = now(), schwab_exit_order_id = '$qNewExitOrderId' WHERE trade_id = '" . $tradeId . "'";
                mysqli_query($conn, $sqlUpdExit);
                print($sqlUpdExit."<br>");

        }elseif ($entryStatus === 'WORKING' || $entryStatus === 'PENDING_ACTIVATION') {
            print($entryStatus . " .. not yet filled.<br>");
        }

    }elseif ($entryOrderId) {
        $entryStatusData = checkSchwabOrderStatus($hashValue, $entryOrderId, $access_token);
        $entryStatus     = $entryStatusData['status']; // e.g. FILLED, PARTIALLY_FILLED, OPEN, CANCELLED
        if ($entryStatus === 'CANCELED' || $entryStatus === 'REJECTED') {
            // Entry never filled => close the trade
            $sqlClose = "UPDATE log SET status = '" . $entryStatus . "' WHERE trade_id = '" . $tradeId . "'";
            mysqli_query($conn, $sqlClose);
            print($sqlClose . "<br>");
            continue;
        }elseif ($entryStatus === 'WORKING' || $entryStatus === 'PENDING_ACTIVATION') {
            //print($entryStatus . " .. not yet filled.<br>");
            continue;
        }elseif ($entryStatus === 'PARTIALLY_FILLED') {
            //print($entryStatus . "<br>");
            continue;
        } elseif ($entryStatus === 'FILLED') {
            // The position is established. Now we can place the exit order if not already placed.
            print($entryStatus . "<br>");
            if (empty($exitOrderId)) {

                if ($biasDb === 'long') {
                    $exitSide = 'SELL';
                } else {
                    $exitSide = 'BUY';
                }

                $newExitOrderId = placeSchwabOrder(
                    $hashValue,
                    $trade['symbol'],
                    $exitSide,
                    'LIMIT',
                    $trade['quantity'],
                    $desiredExit,
                    $accessToken
                );

                $qNewExitOrderId = mysqli_real_escape_string($conn, $newExitOrderId);
                $sqlUpdExit = "UPDATE log SET entry_order_filled = now(), exit_order_entered = now(), schwab_exit_order_id = '$qNewExitOrderId' WHERE trade_id = '" . $tradeId . "'";
                mysqli_query($conn, $sqlUpdExit);
                print($sqlUpdExit . "<br>");

            }

            
        }
    }


    
}

// CLOSE ANYTHING THAT SHOULD BE

// $total_qty = 0;

// $sql = "SELECT * FROM log WHERE symbol = '$symbolEsc' AND status = 'OPEN' and exit_price < '" . $bid . "'";
// $res = mysqli_query($conn, $sql);

// //print($sql . "<br>");

// while ($row = mysqli_fetch_assoc($res)) {

//     $to_close[] = $row['trade_id'];
//     $id = $row['trade_id'];
//     $total_qty += $row['quantity'];

//     print($id . " = " . $row['quantity'] . " @ " . $row['exit_price'] . "<br>");

// }

// if($total_qty > 0){
//     print("total qty to sell = " . $total_qty . "<br>");
//     print("entering an order to sell " . $total_qty . " @ " . $bid . "<br>");


//     $exitOrderId = placeSchwabOrder(
//         $hashValue,
//         $symbol,
//         'SELL',
//         'LIMIT',
//         $total_qty,
//         $bid,
//         $access_token
//     );

//     if($exitOrderId == '200' || $exitOrderId == '201'){
        
//         foreach ($to_close as $key => $value) {
//             print($key . " = " . $value . "<br>");
//             print("Closing trade ID " . $value . "<br>");

//             $sql = "UPDATE log SET exit_order_filled = now(), status = 'CLOSED' WHERE trade_id = '" . $value . "'";
//             $res = mysqli_query($conn, $sql);
//         }

//     }

// }



?></pre>
<!DOCTYPE html>
<html>
<head>
    <title>SPY Ladder Strategy</title>
</head>
<body>

    <hr><b>Open Trades</b><br>
    <table border="1" cellpadding="5" cellspacing="0" style='font-family:monospace; font-size:80%'>
        <tr>
            <th>Trade ID</th>
            <!-- <th>Symbol</th>
            <th>Bias</th> -->
            <th>Entry Price</th>
            <th>Exit Price</th>
            <th>Quantity</th>
            <th>Status</th>
            <th>Order ID</th>
            <th>Entry Entered</th>
            <th>Entry Filled</th>
            <th>Exit Order ID</th>
            <th>Exit Entered</th>
        </tr>
        <?php
        $sqlOpen2 = "
            SELECT *
            FROM log
            WHERE symbol = '$symbolEsc'
              AND status = 'OPEN'
        ";
        $resOpen2 = mysqli_query($conn, $sqlOpen2);
        while ($row = mysqli_fetch_assoc($resOpen2)) {
            echo "<tr>";
            echo "<td>" . $row['trade_id'] . "</td>";
            //echo "<td>" . $row['symbol'] . "</td>";
            //echo "<td>" . $row['bias'] . "</td>";
            echo "<td>" . $row['entry_price'] . "</td>";
            echo "<td>" . $row['exit_price'] . "</td>";
            echo "<td>" . $row['quantity'] . "</td>";
            echo "<td>" . $row['status'] . "</td>";
            echo "<td>" . $row['schwab_order_id'] . "</td>";
            echo "<td>" . $row['created_at'] . "</td>";
            echo "<td>" . $row['entry_order_filled'] . "</td>";
            echo "<td>" . $row['schwab_exit_order_id'] . "</td>";
            echo "<td>" . $row['exit_order_entered'] . "</td>";
            echo "</tr>";
        }
        ?>
    </table>

    <hr><b>Closed Trades</b><br>
    <table border="1" cellpadding="5" cellspacing="0" style='font-family:monospace; font-size:80%'>
        <tr>
            <th>Trade ID</th>
            <!-- <th>Symbol</th>
            <th>Bias</th> -->
            <th>Entry Price</th>
            <th>Exit Price</th>
            <th>Quantity</th>
            <th>Status</th>
            <th>Entry Order ID</th>
            <th>Entry Entered</th>
            <th>Entry Filled</th>
            <th>Exit Order ID</th>
            <th>Exit Entered</th>
            <th>Exit Filled</th>
        </tr>
        <?php
        $sqlClosed = "SELECT * FROM log WHERE symbol = '$symbolEsc' AND status != 'OPEN' and created_at > NOW() - INTERVAL 1 DAY";
        $resClosed = mysqli_query($conn, $sqlClosed);
        while ($row = mysqli_fetch_assoc($resClosed)) {
            echo "<tr>";
            echo "<td>" . $row['trade_id'] . "</td>";
            // echo "<td>" . $row['symbol'] . "</td>";
            // echo "<td>" . $row['bias'] . "</td>";
            echo "<td>" . $row['entry_price'] . "</td>";
            echo "<td>" . $row['exit_price'] . "</td>";
            echo "<td>" . $row['quantity'] . "</td>";
            echo "<td>" . $row['status'] . "</td>";
            echo "<td>" . $row['schwab_order_id'] . "</td>";
            echo "<td>" . $row['created_at'] . "</td>";
            echo "<td>" . $row['entry_order_filled'] . "</td>";
            echo "<td>" . $row['schwab_exit_order_id'] . "</td>";
            echo "<td>" . $row['exit_order_entered'] . "</td>";
            echo "<td>" . $row['exit_order_filled'] . "</td>";
            echo "</tr>";
        }
        ?>
    </table>
  <pre>
<?php
// Always good practice to close DB connection
mysqli_close($conn);
//mysqli_close($mysqli);

// END LADDER TRADING SYSTEM

//include("create_files.php");

//print("<hr>");

$load_time = round((microtime(true) - $_SERVER['REQUEST_TIME_FLOAT']));

//GET PRICE HISTORY
// print("<hr>");
// $price_history = get_price_history($access_token, $ticker);
// print_r($price_history);
// $mysqli = new mysqli("localhost", "root", "", "spybot") or die("Database Connection Failed");
// createTableFromArray($price_history['candles'], 'price_history', $mysqli);

print("<hr>Loaded in " . $load_time . "s");
print("<br>Updating in <span id='timer'>" . $refresh_timer/1000 . "</span>s");

?>
<script>

setTimeout(function(){
   window.location.reload(1);
}, <? print($refresh_timer); ?>);


</script>

<script>
window.focus();
// window.scrollTo({ left: 0, top: document.body.scrollHeight, behavior: "smooth" });

function removeQueryParam(param) {
    const url = new URL(window.location);
    url.searchParams.delete(param);
    window.history.replaceState({}, document.title, url.pathname + url.search);
}

<?php

if($removeGet){
 print("removeQueryParam('cancel');");
}

?>
</script>
<script type="text/javascript">
        window.onload = function() {
            var remainingTime = <?php echo $refresh_timer / 1000; ?>;
            var timerElement = document.getElementById("timer");

            function updateTimer() {
                if (remainingTime > 0) {
                    remainingTime--;
                    timerElement.textContent = remainingTime;
                }
            }

            // Update timer every second
            setInterval(updateTimer, 1000);
        };
    </script>